<!DOCTYPE html>
<html lang="eng">

<head>
    <!-- Meta -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <!-- Page Title -->
    <title><?php echo e($web_title); ?></title>
    <!-- Favicon Icon -->
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e($web_favicon); ?>">
    <!-- Google Fonts Css-->
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Archivo:ital,wght@0,100..900;1,100..900&amp;family=DM+Sans:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000&amp;display=swap"
        rel="stylesheet">

    <!-- Bootstrap Css -->
    <link href="<?php echo e(asset('css/bootstrap.min.css')); ?>" rel="stylesheet" media="screen">

    <!-- SlickNav Css -->
    <link href="<?php echo e(asset('css/slicknav.min.css')); ?>" rel="stylesheet">

    <!-- Swiper Css -->
    <link href="<?php echo e(asset('css/swiper-bundle.min.css')); ?>" rel="stylesheet">

    <!-- Font Awesome Icon Css -->
    <link href="<?php echo e(asset('css/all.css')); ?>" rel="stylesheet" media="screen">

    <!-- Animated Css -->
    <link href="<?php echo e(asset('css/animate.css')); ?>" rel="stylesheet">

    <!-- Magnific Popup Core Css File -->
    <link href="<?php echo e(asset('css/magnific-popup.css')); ?>" rel="stylesheet">

    <!-- Mouse Cursor Css File -->
    <link href="<?php echo e(asset('css/mousecursor.css')); ?>" rel="stylesheet">

    <!-- Main Custom Css -->
    <link href="<?php echo e(asset('css/custom.css')); ?>" rel="stylesheet" media="screen">

</head>

<body>

    <!-- Preloader Start -->
    
    <!-- Preloader End -->

    <!-- Topbar Section Start -->
    <div class="topbar">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-9 col-md-12">
                    <!-- Topbar Contact Information Start -->
                    <div class="topbar-contact-info">
                        <ul>
                            <li><a href="tel:<?php echo e($web_phone); ?>"><img src="<?php echo e(asset('images/icon-phone.svg')); ?>" alt="">
                                    <?php echo e($web_phone); ?></a></li>
                            <li><a href="mailto:<?php echo e($web_email); ?>"><img src="<?php echo e(asset('images/icon-mail.svg')); ?>" alt="">
                                    <?php echo e($web_email); ?></a></li>
                            <li class="hide-mobile"><a href="#"><img src="<?php echo e(asset('images/icon-location.svg')); ?>"
                                        alt=""> <?php echo e($web_address); ?></a></li>
                        </ul>
                    </div>
                    <!-- Topbar Contact Information End -->
                </div>

                <div class="col-lg-3 col-md-0">
                    <!-- Topbar Social Links Start -->
                    <div class="topbar-social-links">
                        <ul>
                            <li><a href="<?php echo e($web_facebook); ?>" target="_blank"><i
                                        class="fa-brands fa-facebook-f"></i></a></li>
                            <li><a href="<?php echo e($web_instagram); ?>" target="_blank"><i
                                        class="fa-brands fa-instagram"></i></a></li>
                            <li><a href="<?php echo e($web_youtube); ?>" target="_blank"><i class="fa-brands fa-youtube"></i></a>
                            </li>
                        </ul>
                    </div>
                    <!-- Topbar Social Links End -->
                </div>
            </div>
        </div>
    </div>
    <!-- Topbar Section End -->

    <!-- Header Start -->
    <header class="main-header">
        <div class="header-sticky">
            <nav class="navbar navbar-expand-lg">
                <div class="container">
                    <!-- Logo Start -->
                    <a class="navbar-brand" href="<?php echo e(route('home')); ?>">
                        <img src="<?php echo e($web_logo); ?>" alt="Logo" width="115">
                    </a>
                    <!-- Logo End -->

                    <!-- Main Menu Start -->
                    <div class="collapse navbar-collapse main-menu">
                        <div class="nav-menu-wrapper">
                            <ul class="navbar-nav mr-auto" id="menu">

                                <li class="nav-item"><a class="nav-link " href="<?php echo e(route('home')); ?>">Home</a></li>
                                <li class="nav-item"><a class="nav-link" href="<?php echo e(route('about')); ?>">About Us</a></li>
                                <li class="nav-item"><a class="nav-link" href="#service-div">Services</a></li>

                                <li class="nav-item"><a class="nav-link" href="<?php echo e(route('contact.page')); ?>">Contact
                                        Us</a></li>
                            </ul>
                        </div>
                        <!-- Let’s Start Button Start -->
                        <div class="header-btn d-inline-flex">
                            <a href="tel:<?php echo e($web_phone); ?>" class="btn-default"><?php echo e($web_phone); ?></a>
                        </div>
                        <!-- Let’s Start Button End -->
                    </div>
                    <!-- Main Menu End -->
                    <div class="navbar-toggle"></div>
                </div>
            </nav>
            <div class="responsive-menu"></div>
        </div>
    </header>
    <!-- Header End -->

    <?php echo $__env->yieldContent('content'); ?>
    <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH G:\Presonal Home\MpknueroHospital\resources\views/layouts/header.blade.php ENDPATH**/ ?>