<?php

use App\Http\Controllers\BlogController;
use App\Http\Controllers\ContactController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\IndexController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/optimize', function () {
    // Clear all cache and optimize project
    Artisan::call('optimize:clear');
    Artisan::call('config:cache');
    Artisan::call('route:cache');
    Artisan::call('view:cache');

    return "✅ Project optimized successfully!";
});

Route::get('/', [IndexController::class, 'index'])->name('home');
Route::get('/about', [IndexController::class, 'about'])->name('about');
Route::get('/blogs', [BlogController::class, 'blogs'])->name('blogs');
Route::get('/blog-detail/{slug}', [BlogController::class, 'blogDetail'])->name('blog.detail');
Route::get('/contact', [ContactController::class, 'contact'])->name('contact.page');
Route::post('/contact-post', [ContactController::class, 'contactPost'])->name('contact.post');


Route::fallback(function () {
    return redirect()->route('notFound');
});

Route::get('/404', function () {
    return view('404');
})->name('notFound');
