<!DOCTYPE html>
<html lang="eng">

<head>
    <!-- Meta -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <!-- Page Title -->
    <title>{{ $web_title }}</title>
    <!-- Favicon Icon -->
    <link rel="shortcut icon" type="image/x-icon" href="{{ $web_favicon }}">
    <!-- Google Fonts Css-->
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Archivo:ital,wght@0,100..900;1,100..900&amp;family=DM+Sans:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000&amp;display=swap"
        rel="stylesheet">

    <!-- Bootstrap Css -->
    <link href="{{ asset('css/bootstrap.min.css') }}" rel="stylesheet" media="screen">

    <!-- SlickNav Css -->
    <link href="{{ asset('css/slicknav.min.css') }}" rel="stylesheet">

    <!-- Swiper Css -->
    <link href="{{ asset('css/swiper-bundle.min.css') }}" rel="stylesheet">

    <!-- Font Awesome Icon Css -->
    <link href="{{ asset('css/all.css') }}" rel="stylesheet" media="screen">

    <!-- Animated Css -->
    <link href="{{ asset('css/animate.css') }}" rel="stylesheet">

    <!-- Magnific Popup Core Css File -->
    <link href="{{ asset('css/magnific-popup.css') }}" rel="stylesheet">

    <!-- Mouse Cursor Css File -->
    <link href="{{ asset('css/mousecursor.css') }}" rel="stylesheet">

    <!-- Main Custom Css -->
    <link href="{{ asset('css/custom.css') }}" rel="stylesheet" media="screen">

</head>

<body>

    <!-- Preloader Start -->
    {{-- <div class="preloader">
        <div class="loading-container">
            <div class="loading"></div>
            <div id="loading-icon"><img src="{{ asset('images/loader.svg') }}" alt=""></div>
        </div>
    </div> --}}
    <!-- Preloader End -->

    <!-- Topbar Section Start -->
    <div class="topbar">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-9 col-md-12">
                    <!-- Topbar Contact Information Start -->
                    <div class="topbar-contact-info">
                        <ul>
                            <li><a href="tel:{{ $web_phone }}"><img src="{{ asset('images/icon-phone.svg') }}" alt="">
                                    {{ $web_phone }}</a></li>
                            <li><a href="mailto:{{ $web_email }}"><img src="{{ asset('images/icon-mail.svg') }}" alt="">
                                    {{ $web_email }}</a></li>
                            <li class="hide-mobile"><a href="#"><img src="{{ asset('images/icon-location.svg') }}"
                                        alt=""> {{ $web_address }}</a></li>
                        </ul>
                    </div>
                    <!-- Topbar Contact Information End -->
                </div>

                <div class="col-lg-3 col-md-0">
                    <!-- Topbar Social Links Start -->
                    <div class="topbar-social-links">
                        <ul>
                            <li><a href="{{ $web_facebook }}" target="_blank"><i
                                        class="fa-brands fa-facebook-f"></i></a></li>
                            <li><a href="{{ $web_instagram }}" target="_blank"><i
                                        class="fa-brands fa-instagram"></i></a></li>
                            <li><a href="{{ $web_youtube }}" target="_blank"><i class="fa-brands fa-youtube"></i></a>
                            </li>
                        </ul>
                    </div>
                    <!-- Topbar Social Links End -->
                </div>
            </div>
        </div>
    </div>
    <!-- Topbar Section End -->

    <!-- Header Start -->
    <header class="main-header">
        <div class="header-sticky">
            <nav class="navbar navbar-expand-lg">
                <div class="container">
                    <!-- Logo Start -->
                    <a class="navbar-brand" href="{{ route('home') }}">
                        <img src="{{ $web_logo }}" alt="Logo" width="115">
                    </a>
                    <!-- Logo End -->

                    <!-- Main Menu Start -->
                    <div class="collapse navbar-collapse main-menu">
                        <div class="nav-menu-wrapper">
                            <ul class="navbar-nav mr-auto" id="menu">

                                <li class="nav-item"><a class="nav-link " href="{{ route('home') }}">Home</a></li>
                                <li class="nav-item"><a class="nav-link" href="{{ route('about') }}">About Us</a></li>
                                <li class="nav-item"><a class="nav-link" href="#service-div">Services</a></li>

                                <li class="nav-item"><a class="nav-link" href="{{ route('contact.page') }}">Contact
                                        Us</a></li>
                            </ul>
                        </div>
                        <!-- Let’s Start Button Start -->
                        <div class="header-btn d-inline-flex">
                            <a href="tel:{{ $web_phone }}" class="btn-default">{{ $web_phone }}</a>
                        </div>
                        <!-- Let’s Start Button End -->
                    </div>
                    <!-- Main Menu End -->
                    <div class="navbar-toggle"></div>
                </div>
            </nav>
            <div class="responsive-menu"></div>
        </div>
    </header>
    <!-- Header End -->

    @yield('content')
    @include('layouts.footer')
