@extends('layouts.header')

@section('content')

<!-- Page Contact Start -->
<div class="page-contact">
    <div class="container">
        <div class="row">
            <div class="col-lg-3 col-md-6">
                <!-- Contact Info Item Start -->
                <div class="contact-info-item wow fadeInUp">
                    <!-- Icon Box Start -->
                    <div class="icon-box">
                        <img src="images/icon-green-location.svg" alt="">
                    </div>
                    <!-- Icon Box End -->

                    <!-- Contact Info Content Start -->
                    <div class="contact-info-content">
                        <h3>location</h3>
                        <p>{{ $web_address }}</p>
                    </div>
                    <!-- Contact Info Content End -->
                </div>
                <!-- Contact Info Item End -->
            </div>

            <div class="col-lg-3 col-md-6">
                <!-- Contact Info Item Start -->
                <div class="contact-info-item wow fadeInUp" data-wow-delay="0.25s">
                    <!-- Icon Box Start -->
                    <div class="icon-box">
                        <img src="images/icon-green-mail.svg" alt="">
                    </div>
                    <!-- Icon Box End -->

                    <!-- Contact Info Content Start -->
                    <div class="contact-info-content">
                        <h3>email</h3>
                        <p>{{ $web_email }}</p>
                    </div>
                    <!-- Contact Info Content End -->
                </div>
                <!-- Contact Info Item End -->
            </div>

            <div class="col-lg-3 col-md-6">
                <!-- Contact Info Item Start -->
                <div class="contact-info-item wow fadeInUp" data-wow-delay="0.5s">
                    <!-- Icon Box Start -->
                    <div class="icon-box">
                        <img src="images/icon-green-phone.svg" alt="">
                    </div>
                    <!-- Icon Box End -->

                    <!-- Contact Info Content Start -->
                    <div class="contact-info-content">
                        <h3>phone</h3>
                        <p>{{ $web_phone }}</p>
                    </div>
                    <!-- Contact Info Content End -->
                </div>
                <!-- Contact Info Item End -->
            </div>

            <div class="col-lg-3 col-md-6">
                <!-- Contact Info Item Start -->
                <div class="contact-info-item wow fadeInUp" data-wow-delay="0.75s">
                    <!-- Icon Box Start -->
                    <div class="icon-box">
                        <img src="images/icon-green-hour.svg" alt="">
                    </div>
                    <!-- Icon Box End -->

                    <!-- Contact Info Content Start -->
                    <div class="contact-info-content">
                        <h3>working hours</h3>
                        <p>{{ $web_time }}</p>
                    </div>
                    <!-- Contact Info Content End -->
                </div>
                <!-- Contact Info Item End -->
            </div>
        </div>
    </div>
</div>
<!-- Page Contact End -->

<!-- Contact Form Start -->
<div class="contact-us-form">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <!-- Contact Us Image Start -->
                <div class="contact-us-img">
                    <figure class="reveal image-anime">
                        <img src="{{ asset('images/my_web/1.jpg') }}" alt="">
                    </figure>
                </div>
                <!-- Contact Us Image End -->
            </div>
            <div class="col-lg-6">
                <div class="contact-form">
                    <!-- Section Title Start -->
                    <div class="section-title">
                        <h3 class="wow fadeInUp">contact us</h3>
                        <h2 class="text-anime-style-2" data-cursor="-opaque"><span>Get</span> In Touch With Us</h2>
                    </div>
                    <!-- Section Title End -->

                    @if (session('success'))
                    <div class="alert alert-success alert-dismissible fade show mt-3" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif

                    <form action="{{ route('contact.post') }}" method="POST" class="wow fadeInUp  formmm"
                        data-wow-delay="0.25s">
                        @csrf
                        <div class="row">

                            {{-- Name --}}
                            <div class="form-group col-md-6 mb-4">
                                <input type="text" name="name" class="form-control @error('name') is-invalid @enderror"
                                    id="fullname" placeholder="Enter Name" value="{{ old('name') }}" required>
                                @error('name')
                                <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>

                            {{-- Phone --}}
                            <div class="form-group col-md-6 mb-4">
                                <input type="text" name="phone"
                                    class="form-control @error('phone') is-invalid @enderror" id="phone"
                                    placeholder="Phone Number" value="{{ old('phone') }}" required>
                                @error('phone')
                                <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>

                            {{-- Subject --}}
                            <div class="form-group col-md-12 mb-4">
                                <input type="text" name="subject"
                                    class="form-control @error('subject') is-invalid @enderror" id="subject"
                                    placeholder="Subject" value="{{ old('subject') }}" required>
                                @error('subject')
                                <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>

                            {{-- Message --}}
                            <div class="form-group col-md-12 mb-5">
                                <textarea name="msg" class="form-control @error('msg') is-invalid @enderror" id="msg"
                                    rows="5" placeholder="Your Message" required>{{ old('msg') }}</textarea>
                                @error('msg')
                                <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>

                            {{-- Submit --}}
                            <div class="col-md-12">
                                <button type="submit" class="btn-default">Send Message</button>
                            </div>
                        </div>
                    </form>


                </div>
            </div>
        </div>
    </div>
</div>
<!-- Contact Form End -->

<!-- Google Map Start -->
<div class="google-map">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <!-- Google Map Iframe Start -->
                <div class="google-map-iframe">
                    <iframe
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d4282.234830179249!2d75.47045159999999!3d29.277470800000003!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3913d978f98fc9bd%3A0x82e1a7d6e38af2c8!2sM%20P%20K%20Nero%20Health%20Care%20Center!5e1!3m2!1sen!2sin!4v1759598733190!5m2!1sen!2sin"
                        width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy"
                        referrerpolicy="no-referrer-when-downgrade"></iframe>
                </div>
                <!-- Google Map Iframe End -->
            </div>
        </div>
    </div>
</div>
<!-- Google Map End -->



@endsection
