@extends('layouts.header')

@section('content')

    <!-- Page Header Start -->
	<div class="page-header">
		<div class="container">
			<div class="row">
				<div class="col-lg-12">
					<!-- Page Header Box Start -->
					<div class="page-header-box">
						<h1 class="text-anime-style-2">About Us</h1>

					</div>
					<!-- Page Header Box End -->
				</div>
			</div>
		</div>
	</div>
	<!-- Page Header End -->

    <!-- About Us Start -->
<div class="about-us">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <!-- About Image Start -->
                <div class="about-us-image">
                    <div class="about-img">
                        <figure class="reveal image-anime">
                            <img src="{{ asset('images/my_web/1.jpg') }}" alt="">
                        </figure>

                        <!-- Company Experience Box Start -->
                        <div class="company-experience">
                            <div class="icon-box">
                                <img src="images/icon-experience.svg" alt="">
                            </div>
                            <div class="company-experience-content">
                                <h3><span class="counter">5</span>+</h3>
                                <p>years of experience</p>
                            </div>
                        </div>
                        <!-- Company Experience Box End -->
                    </div>
                </div>
                <!-- About Image End -->
            </div>
            <div class="col-lg-6">
                <!-- About Us Content Start -->
                <div class="about-content">
                    <!-- Section Title Start -->
                    <div class="section-title">
                        <h3 class="wow fadeInUp">about us</h3>
                        <h2 class="text-anime-style-2" data-cursor="-opaque">
                            We Care For Your <span>Better Movement</span>
                        </h2>
                        <p class="wow fadeInUp" data-wow-delay="0.25s">
                            At <strong>M.P.K. Neuro Health Care Center</strong>, we provide advanced <strong>Neuro
                                Physiotherapy</strong>
                            and <strong>Full Body Rehabilitation</strong> treatments. Our goal is to help you restore
                            strength, improve mobility,
                            and live a pain-free life through expert hands and modern physiotherapy techniques.
                        </p>
                    </div>
                    <!-- Section Title End -->

                    <!-- About Us Body Start -->
                    <div class="about-us-body">
                        <!-- About List Item Start -->
                        <div class="about-list-item wow fadeInUp" data-wow-delay="0.5s">
                            <div class="icon-box">
                                <img src="{{ asset('images/icon-about-us-1.svg') }}" alt="">
                            </div>
                            <div class="about-list-content">
                                <h3>Advanced Neuro Therapy</h3>
                            </div>
                        </div>
                        <!-- About List Item End -->

                        <!-- About List Item Start -->
                        <div class="about-list-item wow fadeInUp" data-wow-delay="0.5s">
                            <div class="icon-box">
                                <img src="{{ asset('images/icon-about-us-2.svg') }}" alt="">
                            </div>
                            <div class="about-list-content">
                                <h3>Personalized Exercise Plans</h3>
                            </div>
                        </div>
                        <!-- About List Item End -->

                        <!-- About List Item Start -->
                        <div class="about-list-item wow fadeInUp" data-wow-delay="0.75s">
                            <div class="icon-box">
                                <img src="{{ asset('images/icon-about-us-3.svg') }}" alt="">
                            </div>
                            <div class="about-list-content">
                                <h3>Pain Management Therapy</h3>
                            </div>
                        </div>
                        <!-- About List Item End -->

                        <!-- About List Item Start -->
                        <div class="about-list-item wow fadeInUp" data-wow-delay="0.75s">
                            <div class="icon-box">
                                <img src="{{ asset('images/icon-about-us-4.svg') }}" alt="">
                            </div>
                            <div class="about-list-content">
                                <h3>Care, Support & Motivation</h3>
                            </div>
                        </div>
                        <!-- About List Item End -->
                    </div>
                    <!-- About Us Body End -->

                    <!-- About Us Footer Start -->
                    <div class="about-us-footer">
                        <!-- Doctor Info Start -->
                        <div class="doctor-info wow fadeInUp" data-wow-delay="1s">
                            <div class="doctor-info-item">
                                <div class="image-box">
                                    <figure class="image-anime">
                                        <img src="{{ asset('images/my_web/profile.jpg') }}" alt="Dr. Ravinder Dahiya">
                                    </figure>
                                </div>
                                <div class="doctor-info-content">
                                    <h3>Dr. Ravinder Dahiya</h3>
                                    <p>Senior Physiotherapist & Rehabilitation Expert</p>
                                </div>
                            </div>
                        </div>
                        <!-- Doctor Info End -->

                        <!-- Appointment Button Start -->
                        <div class="appointment-btn wow fadeInUp" data-wow-delay="1s">
                            <a href="{{ route('contact.page') }}" class="btn-default">Book Your Appointment</a>
                        </div>
                        <!-- Appointment Button End -->
                    </div>
                    <!-- About Us Footer End -->
                </div>
                <!-- About Us Content End -->
            </div>

        </div>
    </div>
</div>
<!--  About Us End -->

    <!-- Company Counter Start -->
    <div class="company-counter">
        <div class="container">
            <div class="row">
                <div class="col-lg-3 col-md-6">
                    <!-- Company Counter Item Start -->
                    <div class="company-counter-item">
                        <!-- Icon Box Start -->
                        <div class="icon-box">
                            <img src="images/icon-counter-1.svg" alt="">
                        </div>
                        <!-- Icon Box End -->

                        <!-- Company Counter Content Start -->
                        <div class="company-counter-content">
                            <h3><span class="counter">78</span>+</h3>
                            <p>skilled therapist</p>
                        </div>
                        <!-- Company Counter Content End -->
                    </div>
                    <!-- Company Counter Item End -->
                </div>

                <div class="col-lg-3 col-md-6">
                    <!-- Company Counter Item Start -->
                    <div class="company-counter-item">
                        <!-- Icon Box Start -->
                        <div class="icon-box">
                            <img src="images/icon-counter-2.svg" alt="">
                        </div>
                        <!-- Icon Box End -->

                        <!-- Company Counter Content Start -->
                        <div class="company-counter-content">
                            <h3><span class="counter">98</span>%</h3>
                            <p>success rate</p>
                        </div>
                        <!-- Company Counter Content End -->
                    </div>
                    <!-- Company Counter Item End -->
                </div>

                <div class="col-lg-3 col-md-6">
                    <!-- Company Counter Item Start -->
                    <div class="company-counter-item">
                        <!-- Icon Box Start -->
                        <div class="icon-box">
                            <img src="images/icon-counter-3.svg" alt="">
                        </div>
                        <!-- Icon Box End -->

                        <!-- Company Counter Content Start -->
                        <div class="company-counter-content">
                            <h3><span class="counter">950</span>+</h3>
                            <p>patients treated</p>
                        </div>
                        <!-- Company Counter Content End -->
                    </div>
                    <!-- Company Counter Item End -->
                </div>

                <div class="col-lg-3 col-md-6">
                    <!-- Company Counter Item Start -->
                    <div class="company-counter-item">
                        <!-- Icon Box Start -->
                        <div class="icon-box">
                            <img src="images/icon-counter-4.svg" alt="">
                        </div>
                        <!-- Icon Box End -->

                        <!-- Company Counter Content Start -->
                        <div class="company-counter-content">
                            <h3><span class="counter">78</span>+</h3>
                            <p>Skilled Therapist</p>
                        </div>
                        <!-- Company Counter Content End -->
                    </div>
                    <!-- Company Counter Item End -->
                </div>
            </div>
        </div>
    </div>
    <!-- Company Counter End -->

   <!-- Mission Vision Start -->
<div class="mission-vision">
    <div class="container">
        <div class="row section-row">
            <div class="section-title">
                <h3 class="wow fadeInUp">vision to victory</h3>
                <h2 class="text-anime-style-2" data-cursor="-opaque"><span>We're a Recognized</span> & Quality Leader</h2>
            </div>
        </div>

        <div class="row">
            <!-- Mission -->
            <div class="col-lg-4 col-md-6">
                <div class="our-mva-item wow fadeInUp">
                    <div class="icon-box">
                        <img src="images/icon-our-mission.svg" alt="">
                    </div>
                    <div class="mva-item-content">
                        <h3>our mission</h3>
                        <p>Our mission is to restore mobility, strength, and confidence through personalized neuro and physiotherapy care designed for every patient’s unique needs.</p>
                    </div>
                </div>
            </div>

            <!-- Vision -->
            <div class="col-lg-4 col-md-6">
                <div class="our-mva-item wow fadeInUp" data-wow-delay="0.25s">
                    <div class="icon-box">
                        <img src="images/icon-our-vision.svg" alt="">
                    </div>
                    <div class="mva-item-content">
                        <h3>our vision</h3>
                        <p>We aim to become a trusted physiotherapy and rehabilitation leader recognized for innovation, patient satisfaction, and long-term health recovery.</p>
                    </div>
                </div>
            </div>

            <!-- Approach -->
            <div class="col-lg-4 col-md-6">
                <div class="our-mva-item wow fadeInUp" data-wow-delay="0.5s">
                    <div class="icon-box">
                        <img src="images/icon-our-approch.svg" alt="">
                    </div>
                    <div class="mva-item-content">
                        <h3>our approach</h3>
                        <p>We combine scientific techniques with hands-on therapies, advanced technology, and compassionate guidance to ensure complete recovery and wellness.</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- CTA -->
        <div class="cta-infobar wow fadeInUp" data-wow-delay="0.75s">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="cta-info-content">
                        <div class="icon-box">
                            <img src="images/icon-cta.svg" alt="">
                        </div>
                        <div class="cta-content">
                            <h3>ready to start your journey to recovery?</h3>
                            <p>Book your consultation now and take the first confident step toward a pain-free, stronger, and healthier life today.</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="cta-appointment-btn">
                        <a href="#" class="btn-default">book appointment</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Mission Vision End -->

<!-- Quality Treatment Section Start -->
<div class="quality-treatment">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="quality-treatment-video" data-cursor-text="Play">
                    <div class="video-image">
                        <a href="https://www.youtube.com/watch?v=Y-x0efG1seA" class="popup-video">
                            <figure class="image-anime">
                                <img src="{{ asset('images/my_web/5.jpg') }}" alt="">
                            </figure>
                        </a>
                    </div>
                    <div class="video-play-button">
                        <a href="https://www.youtube.com/watch?v=Y-x0efG1seA" class="popup-video">
                            <i class="fa-solid fa-play"></i>
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="quality-treatment-content">
                    <div class="section-title">
                        <h3 class="wow fadeInUp">solution to your pain</h3>
                        <h2 class="text-anime-style-2" data-cursor="-opaque"><span>We Proudly</span> Give Quality Treatment</h2>
                        <p class="wow fadeInUp" data-wow-delay="0.25s">At M.P.K. Neuro Health Care Center, we focus on holistic healing using modern physiotherapy methods, manual therapy, and advanced pain-relief techniques for every patient.</p>
                    </div>

                    <div class="quality-treatment-body wow fadeInUp" data-wow-delay="0.5s">
                        <ul>
                            <li>Comprehensive neuro and physiotherapy treatments.</li>
                            <li>Personalized exercise and recovery programs.</li>
                            <li>Focused care for long-term physical wellness.</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Quality Treatment Section End -->

<!-- Therapy Process Start -->
<div class="therapy-process">
    <div class="container">
        <div class="row section-row">
            <div class="col-lg-12">
                <div class="section-title">
                    <h3 class="wow fadeInUp">therapy process</h3>
                    <h2 class="text-anime-style-2" data-cursor="-opaque"><span>Our Step-by-Step</span> Therapy Process</h2>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Step 1 -->
            <div class="col-lg-3 col-md-6">
                <div class="therapy-process-item wow fadeInUp">
                    <div class="icon-box">
                        <figure class="image-anime">
                            <img src="images/therapy-process-1.jpg" alt="">
                        </figure>
                    </div>
                    <div class="therapy-process-content">
                        <h3>get paired with a therapist</h3>
                        <p>Our experts assess your pain and assign a specialist best suited to your recovery needs and health goals.</p>
                    </div>
                </div>
            </div>

            <!-- Step 2 -->
            <div class="col-lg-3 col-md-6">
                <div class="therapy-process-item wow fadeInUp" data-wow-delay="0.25s">
                    <div class="icon-box">
                        <figure class="image-anime">
                            <img src="images/therapy-process-2.jpg" alt="">
                        </figure>
                    </div>
                    <div class="therapy-process-content">
                        <h3>customized treatment plan</h3>
                        <p>We create a structured therapy plan focused on pain reduction, improved movement, and long-term body balance.</p>
                    </div>
                </div>
            </div>

            <!-- Step 3 -->
            <div class="col-lg-3 col-md-6">
                <div class="therapy-process-item wow fadeInUp" data-wow-delay="0.5s">
                    <div class="icon-box">
                        <figure class="image-anime">
                            <img src="images/therapy-process-3.jpg" alt="">
                        </figure>
                    </div>
                    <div class="therapy-process-content">
                        <h3>targeted therapy sessions</h3>
                        <p>Regular sessions are conducted using physiotherapy, cupping, and exercise techniques for faster recovery and relief.</p>
                    </div>
                </div>
            </div>

            <!-- Step 4 -->
            <div class="col-lg-3 col-md-6">
                <div class="therapy-process-item wow fadeInUp" data-wow-delay="0.75s">
                    <div class="icon-box">
                        <figure class="image-anime">
                            <img src="images/therapy-process-4.jpg" alt="">
                        </figure>
                    </div>
                    <div class="therapy-process-content">
                        <h3>long-term health guidance</h3>
                        <p>We guide you through exercises, posture correction, and lifestyle care to maintain pain-free living permanently.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Therapy Process End -->





@endsection
