<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ContactModel;
class ContactController extends Controller
{
    public function contact()
    {
        return view('contact');
    }
    public function contactPost(Request $request)
    {
      $validated = $request->validate([
        'name' => 'required|string|max:100',
        'phone' => ['required', 'digits:10'], // exactly 10 digits
        'subject' => 'required|string|max:150',
        'msg' => ['required', 'string', 'max:1000', 'regex:/^[a-zA-Z0-9\s.,!?-]+$/'], // no special symbols
    ], [
        'msg.regex' => 'Message contains invalid characters.',
        'phone.digits' => 'Phone must be exactly 10 digits.',
    ]);

    // Insert into database
    ContactModel::create([
        'name' => $validated['name'],
        'phone' => $validated['phone'],
        'subject' => $validated['subject'],
        'message' => $validated['msg'],
    ]);



    // Otherwise normal redirect
    return redirect()->back()->with('success', 'Your message has been sent successfully!');
    }
}
